############### ###############
## F_H3_2
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  pct_format = scales::percent_format(accuracy = .1)

  ggplot(DM_final,
         aes(x = factor(pressure_civilsociety))) + 
    labs(
      x = "Perceived likelihood of civil society pressure if their municipality \n fails to delivery on its responsibilities without good justification", 
      y = "Number of decision makers"
    ) +
    geom_bar() +
    scale_x_discrete(labels = c('Impossible',
                                'Very unlikely', 
                                'Somewhat unlikely', 
                                'Somewhat likely', 
                                'Very likely', 
                                'Certain', 
                                'Missing'),
                     guide = guide_axis(angle = 45)) +
    geom_text(aes(
      label = sprintf('%d \n (%s)',
                      ..count..,
                      pct_format(..count.. / sum(..count..)))),
      stat = 'count',
      nudge_y = .2,
      colour = 'black',
      size = 2.5, 
      vjust = -0.2) + 
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) + 
    scale_y_continuous(limits = c(0,700))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H3_", "2.png"), device = png,  dpi=200)



